#!/bin/bash

getAppInfo() {
    _app_name="$1"

    _app_info=`ps aux | grep "$_app_name" | grep -v grep`

    _app_user=`echo "$_app_info" | awk {'print $1'}`
    _app_pid=`echo "$_app_info" | awk {'print $2'}`
    _app_cpu=`echo "$_app_info" | awk {'print $3'}`

    echo "[${_app_name}] user: ${_app_user}, pid: ${_app_pid}, cpu: ${_app_cpu}"
}

OSX_VER=`sw_vers -productVersion`
echo "OSX: ${OSX_VER}"

app_name="MacOS/SRStreamerDaemon"
app_streamer="MacOS/Splashtop Streamer"

sudo rm -r /tmp/com.splashtop.*
sudo chown root /tmp
sudo chown root /private/tmp
sudo chmod +t /tmp

# check default port
sudo lsof -P -n -i:6783

getAppInfo "${app_name}"
getAppInfo "${app_streamer}"

app_pid=`ps aux | grep "$app_name" | grep -v grep | awk {'print $2'}`

echo ""
echo `ps aux | grep "$app_streamer" | grep -v grep`
echo ""

echo `ps aux | grep "$app_name" | grep -v grep`
if [ ! -z "${app_pid}" ]; then
    sudo kill -9 ${app_pid}
    sleep 1
fi

echo `ps aux | grep "$app_name" | grep -v grep`
